<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\Shipment;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function about()
    {
        $data = ['title' => 'About Us'];

        return view('pages.about', $data);
    }
    public function services()
    {
        $data = ['title' => 'Services'];

        return view('pages.services', $data);
    }
    public function contact()
    {
        $data = ['title' => 'Contact Us'];

        return view('pages.contact', $data);
    }
    public function contactStore(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required'
        ]);

        $data['uuid'] = Str::uuid();

        Contact::create($data);

        return redirect()->route('contact')->with('success', 'Message sent successfully');
    }
    public function faq()
    {
        $data = ['title' => 'Frequently Asked Questions'];

        return view('pages.faq', $data);
    }
    public function cargoTracking()
    {

        $data = ['title' => 'Cargo Tracking'];
        return view('pages.cargo_tracking', $data);
    }

    public function cargoTrackingStore(Request $request)
    {

        $request->validate([
            'tracking_code' => 'required',
        ]);

        $shipment = Shipment::where('tracking_code', $request->tracking_code)->first();

        if (!$shipment) {
            return redirect()->back()->with('error', 'Invalid tracking code');
        }

        return redirect()->route('cargo.tracking.details', $shipment->uuid)->with('success', 'Shipment found');
    }

    public function cargoTrackingDetail($uuid)
    {

        $shipment = Shipment::where('uuid', $uuid)->first();
        $shipmentLocations = $shipment->shipmentLocations()->orderBy('id', 'desc')->get();

        $data = [
            'title' => 'Cargo Tracking Details',
            'shipment' => $shipment,
            'shipmentLocations' => $shipmentLocations
        ];

        return view('pages.cargo_tracking_details', $data);
    }
}
