<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->uuid();
            $table->integer('admin_id');
            $table->string('sender_name')->nullable();
            $table->string('sender_address')->nullable();
            $table->string('sender_phone')->nullable();
            $table->string('sender_email')->nullable();
            $table->string('client_name')->nullable();
            $table->string('client_address')->nullable();
            $table->string('client_phone')->nullable();
            $table->string('client_email')->nullable();
            $table->longText('description')->nullable();
            $table->string('weight')->nullable();
            $table->string('shipped_from')->nullable();
            $table->string('shipment_amount')->nullable();
            $table->string('expected_delivery_date')->nullable();
            $table->string('pickup_location')->nullable();
            $table->string('date_of_shipment')->nullable();
            $table->string('quantity')->nullable();
            $table->string('length')->nullable();
            $table->string('width')->nullable();
            $table->string('height')->nullable();
            $table->string('pickup_time')->nullable();
            $table->string('departure_time')->nullable();
            $table->string('comment')->nullable();
            $table->string('type_of_shipment')->nullable();
            $table->string('total_freight')->nullable();
            $table->string('payment_mode')->nullable();
            $table->string('product')->nullable();
            $table->string('mode')->nullable();
            $table->string('carrier_reference_no')->nullable();
            $table->string('carrier')->nullable();
            $table->string('image')->nullable();
            $table->string('tracking_code')->nullable();
            $table->string('status')->default('PickedUp');
            $table->string('current_location')->nullable();
            $table->string('currency')->nullable();
            $table->string('last_update')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipments');
    }
};
