<?php

namespace Database\Seeders;

use App\Models\Shipment;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ShipmentTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Shipment::updateOrCreate(
            [
                'id' => 1
            ],
            [
                'uuid' => Str::uuid(),
                'admin_id' => 1,
                'sender_name' => fake()->name(),
                'sender_address' => fake()->address(),
                'sender_phone' => fake()->phoneNumber(),
                'sender_email' => fake()->email(),
                'client_name' => fake()->name(),
                'client_address' => fake()->address(),
                'client_phone' => fake()->phoneNumber(),
                'client_email' => fake()->email(),
                'description' => fake()->sentence(50),
                'weight' => fake()->numberBetween(1, 10),
                'shipped_from' => fake()->country(),
                'shipment_amount' => fake()->numberBetween(600, 1000),
                'expected_delivery_date' => now()->addDays(7)->toDateString(),
                'pickup_location' => fake()->country(),
                'date_of_shipment' => now()->toDateString(),
                'quantity' => '10',
                'length' => '20',
                'width' => '15',
                'height' => '10',
                'pickup_time' => now()->toTimeString(),
                'departure_time' => now()->toTimeString(),
                'comment' => fake()->sentence(10),
                'type_of_shipment' => 'Standard',
                'total_freight' => '150.00',
                'payment_mode' => 'Credit Card',
                'product' => 'Electronics',
                'mode' => 'Air',
                'carrier_reference_no' => Str::random(10),
                'carrier' => 'Carrier Name',
                'image' => 'image.jpg',
                'tracking_code' => getTrackingNumber(config('app.name')),
                'status' => 'PickedUp',
                'current_location' => fake()->country(),
                'currency' => 'Nigerian Naira-NGN-₦',
                'last_update' => now()->toDateTimeString(),
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );
    }
}
