@extends('dashboard.admin.layouts.master')
@section('content')
    <section class="section">
        @include('dashboard.admin.partials.banner_area')
        <div class="section-body">
            <div class="row">
                <div class="col-md-12">
                    @include('partials.email_message')
                    @include('partials.sweet_alert')
                    <div class="card">
                        <div class="card-body">
                            <form action="{{ route('admin.contact.send', $contact->uuid) }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <dl>
                                        <dt>Name</dt>
                                        <dd>{{ $contact->name }}</dd>
                                        <dt>Email</dt>
                                        <dd>{{ $contact->email }}</dd>
                                        <dt>Subject</dt>
                                        <dd>{{ $contact->subject }}</dd>
                                        <dt>Message</dt>
                                        <dd>{{ $contact->message }}</dd>
                                    </dl>
                                </div>
                                <div class="form-group">
                                    <label for="message">Message</label>
                                    <textarea name="message" class="summernote"></textarea>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">Send</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
