@extends('dashboard.admin.layouts.master')
@section('content')
    <section class="section">
        @include('dashboard.admin.partials.banner_area')
        <div class="section-body">
            <h2 class="section-title">Hi, {{ auth('admin')->user()->name }}!</h2>
            <p class="section-lead">
                Change information about yourself on this page.
            </p>

            <div class="row mt-sm-4">
                <div class="col-12 col-md-12 col-lg-12">
                    @include('partials.validation_message')
                    <div class="card">
                        <form action="{{ route('admin.dashboard.profile.update') }}" method="POST">
                            @csrf
                            <div class="card-header">
                                <h4>Edit Profile</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-md-6 col-12">
                                        <label>Name</label>
                                        <input type="text" class="form-control" value="{{ $admin->name }}"
                                            name="name">
                                    </div>
                                    <div class="form-group col-md-6 col-12">
                                        <label>Email</label>
                                        <input type="email" class="form-control" value="{{ $admin->email }}"
                                            name="email">
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-right">
                                <button class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
