<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
    </head>

    <body style="font-family: Arial, Helvetica, sans-serif;">

        <div>

            <table style="width:100%;">
                <tr style="width:100%;">
                    <td>
                        <img style="width:70%;" src="{{ public_path('/logo/logo.png') }}">
                    </td>

                    <td>
                        <span style="line-height: 5px;">
                            <p style="font-size: larger; text-align: right;"><b> Contact US </b></p>
                            <p style="font-size: 10px; text-align: right;">Address: {{ config('app.address') }}</p>
                            <p style="font-size: 10px; text-align: right;">{{ config('app.email') }}</p>
                        </span>
                    </td>

                    <td>
                        <img style="width: 100px; object-fit: cover;"
                            src="{{ public_path('/dashboard/assets/img/qr-code.png') }}">
                    </td>
                </tr>
            </table>

            <div style="background-color: red; color: white; font-size: 30px; font-weight: bolder;">
                <span style="font-family: Times New Roman, Times, serif;"> Shipment Receipt</span>
            </div>

            <div style="color: white; margin-top: 10px;">
                <span style=" background-color: red; padding:3px 40px 3px 0px;"> Tracking ID:
                    {{ $shipment->tracking_code }}</span>
                <span style="color: #DC505E;">Date of
                    shipment:{{ date('d M, Y', strtotime($shipment->date_of_shipment)) }}</span>
            </div>

            <div style="font-size: small; padding: 30px 0px; width: 100%;">
                <div>
                    <table style="width: 100%; color: #1E89FB;">
                        <tr>
                            <td> Sender:</td>
                            <td style="font-size: larger;">
                                <b>{{ $shipment->sender_name }}</b>
                            </td>

                            <td style="text-align: right;"> Receiver:</td>
                            <td style="font-size: larger;">
                                <b>{{ $shipment->client_name }}</b>
                            </td>

                        </tr>

                        <tr>
                            <td> Address:</td>
                            <td>{{ $shipment->sender_address }}</td>

                            <td> </td>
                            <td>{{ $shipment->client_address }}</td>
                        </tr>

                        <tr>
                            <td>Email:</td>
                            <td>{{ $shipment->sender_email }}</td>

                            <td></td>
                            <td>{{ $shipment->client_email }}</td>
                        </tr>

                        <tr>
                            <td>Phone:</td>
                            <td>{{ $shipment->sender_phone }}</td>

                            <td></td>
                            <td>{{ $shipment->client_phone }}</td>
                        </tr>

                        <tr>
                            <td>Amount:</td>
                            <td>{{ currency($shipment->currency, 'code') }}
                                {{ formatAmount($shipment->shipment_amount) }}
                            </td>

                            <td style="text-align: right;"><b>Pickup Location:</b></td>
                            <td>
                                {{ $shipment->pickup_location }}
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <table style="color: white; width: 100%;">
                <tr>
                    <td style="padding: 10px 5px; width: 40%; background-color: red;">
                        <span>
                            PARCEL DESCRIPTION
                        </span>
                    </td>
                    <td style=" padding: 10px 3px; width: 60%; background-color:#107481b9;">
                        <span>
                            EXPECTED DATE OF DELIVERY:
                            {{ date('d M, Y', strtotime($shipment->expected_delivery_date)) }}
                        </span>
                    </td>
                </tr>
            </table>

            <div>
                <P><b style="font-size: larger;">{{ $shipment->description }}</b></P>
                <p> <b>Weight:</b> {{ $shipment->weight }}Kg</p>
                <p> <b>Comment:</b> </br> {{ $shipment->comment }}</p>
            </div>

            <div style="width: 100%;">
                <p style="font-size: larger;">
                    Any shortage or damage must be notified withing 72hours of receipt of goods. Complaints can only
                    Be accepted if made in writing within 30days of receipt of goods. No goods may be returned without
                    Prior authorization from {{ config('app.name') }}
                </p>
            </div>

            <div style="display:flex;">

                <div style="margin-left: 5px;">
                    <table>
                        <tr>
                            <td>
                                <img src="{{ public_path('/dashboard/assets/img/paypal2.png') }}">
                            </td>
                            <td>
                                <div style=" font-size: smaller; color: rgb(145, 143, 143);">
                                    Credit & Debits Cards Accepted
                                </div>
                                <img src="{{ public_path('/dashboard/assets/img/paypal.png') }}">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <div style="border-bottom: 2px solid black; height: 105px;">
                <span>
                    <img src="{{ public_path('/dashboard/assets/img/sign.png') }}">
                </span>
            </div>

            <div style="font-size: small; margin-left: 100px;">
                Signed
            </div>

            <!-- stamp image -->
            <div style="margin: -200px 0px 0px 0px; float: right;">
                <img src="{{ public_path('/dashboard/assets/img/dispatch.png') }}"
                    style="width: 300px; object-fit: cover;">
            </div>

        </div>

    </body>

</html>
