<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- Favicon -->
        <link rel="shortcut icon" href="/logo/logo.png">

        <?php if(isset($title)): ?>
            <title><?php echo e($title); ?> &mdash; <?php echo e(config('app.name')); ?></title>
        <?php else: ?>
            <title><?php echo e(config('app.name')); ?></title>
        <?php endif; ?>

        <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:description"
            content="We believe that the services offered by us should satisfy the high expectations
of our customers. We are dedicated in creating added value for our
customers by implementing modern technology in our work. That is why the desire of
constant improvement is the driving force behind our transportation business." />
        <meta property="og:image" content="<?php echo e(asset('assets/img/site_image.jpg')); ?>" />
        <meta property="og:type" content="website" />
        <script src="/assets/js/sweetalert.js"></script>
        <link rel="stylesheet"
            href="https://fonts.googleapis.com/css?family=Roboto:400,500,700%7cPoppins:400,600,700&amp;display=swap" />
        <link rel="stylesheet" href="/assets/css/libraries.css" />
        <link rel="stylesheet" href="/assets/css/style.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            #google_translate_element {
                display: inline-block;
            }

            .goog-te-gadget-icon {
                background-image: url('https://www.gstatic.com/images/branding/googlelogo/2x/googlelogo_light_color_92x30dp.png');
                background-size: 92px 30px;
            }

            .goog-te-gadget-simple {
                border: 1px solid #ccc;
                padding: 5px;
                border-radius: 5px;
            }

            .goog-te-gadget-simple .goog-te-menu-value {
                color: #333;
            }
        </style>

        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({
                    pageLanguage: 'en',
                    autoDisplay: false
                }, 'google_translate_element');
            }
        </script>

        <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
        </script>
    </head>

    <body>
        <div class="wrapper">

            <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>

            <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="module__search-container">
                <i class="fa fa-times close-search"></i>
                <form class="module__search-form">
                    <input type="text" class="search__input" placeholder="Type Words Then Enter" />
                    <button class="module__search-btn">
                        <i class="fa fa-search"></i>
                    </button>
                    <div style="display:none"><label>Fill This Field</label><input type="hidden" name="honeypot"
                            value="" />
                    </div>
                </form>
            </div>

            <button id="scrollTopBtn"><i class="fa fa-long-arrow-up"></i></button>
        </div>

        <script src="/assets/js/jquery-3.3.1.min.js"></script>
        <script src="/assets/js/plugins.js"></script>
        <script src="/assets/js/main.js"></script>
        <?php echo $__env->make('partials.live_chat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\layouts\master.blade.php ENDPATH**/ ?>